Option Strict Off
Option Explicit On
Module Module1
    '// 1. コンピュータに接続された Rockey2 ドングルを検索
    Declare Function RY2_Find Lib "ROCKEY2.DLL" () As Integer
    '// 戻り値:
    '// 0未満の場合 -> エラーコードを返す（詳細はエラーコード一覧を参照）。
    '// 0の場合 -> Rockey2 デバイスが存在しない。
    '// 0より大きい場合 -> 見つかった Rockey2 ドングルの数を返す。

    '// ====================================================================
    '// 2. 指定したドングルを開く
    Declare Function RY2_Open Lib "ROCKEY2.DLL" (ByVal mode As Integer, ByVal uid As Integer, ByRef hid As Integer) As Integer

    '// 入力:
    '// mode - ドングルの開き方を指定
    '// mode = 0 -> 最初に見つかった Rockey2 を開く（UID・HIDは無視）。
    '// mode > 0 -> UID を指定して開く（例: uid=12345678, mode=2 は 12345678 の2番目のドングルを開く）。
    '// mode = -1 -> HID を指定して開く（hid の値が 0 でないこと）。

    Public Const AUTO_MODE As Short = 0
    Public Const HID_MODE As Short = -1

    '// uid（ユーザーID）
    '// UID を指定して開く場合、この UID を使用。
    '// hid（ハードウェアID）
    '// HID を指定して開く場合、この HID を使用。
    '// 成功すると、開いたドングルのハードウェアIDが返される。

    '// 戻り値:
    '// 0以上 -> 成功（返された値はドングルのハンドル）。
    '// 0未満 -> エラーコード（詳細はエラーコード一覧を参照）。

    '// ====================================================================
    '// 3. 指定したドングルを閉じる
    Declare Sub RY2_Close Lib "ROCKEY2.DLL" (ByVal handle As Integer)
    '// 入力:
    '// handle - RY2_Open の戻り値と同じハンドル。
    '// 戻り値:
    '// エラーコードを返す（詳細はエラーコード一覧を参照）。

    '// ====================================================================
    '// 4. ユーザーIDを生成
    Declare Function RY2_GenUID Lib "ROCKEY2.DLL" (ByVal handle As Integer, ByRef uid As Integer, ByVal seed As String, ByVal isProtect As Integer) As Integer
    '// 入力:
    '// handle - RY2_Open の戻り値と同じハンドル。
    '// uid - 生成されたユーザーIDを格納する変数。
    '// seed - ユーザーID生成に使用する最大64バイトの文字列。
    '// isProtect - 予約済み（0 に設定）。
    '// 戻り値:
    '// エラーコードを返す（詳細はエラーコード一覧を参照）。

    '// ====================================================================
    '// 5. ドングルのデータを読み取る
    Declare Function RY2_Read Lib "ROCKEY2.DLL" (ByVal handle As Integer, ByVal block_index As Integer, ByVal buffer512 As String) As Integer
    '// 入力:
    '// handle - RY2_Open の戻り値と同じハンドル。
    '// block_index - 読み取るブロックのインデックス（0～4）。
    '// buffer512 - 512バイトのバッファ（読み取ったデータを格納）。
    '// 戻り値:
    '// エラーコードを返す（詳細はエラーコード一覧を参照）。

    '// ====================================================================
    '// 6. ドングルのデータを書き込む
    Declare Function RY2_Write Lib "ROCKEY2.DLL" (ByVal handle As Integer, ByVal block_index As Integer, ByVal buffer512 As String) As Integer
    '// 入力:
    '// handle - RY2_Open の戻り値と同じハンドル。
    '// block_index - 書き込むブロックのインデックス（0～4）。
    '// buffer512 - 512バイトのバッファ（書き込むデータ）。
    '// 戻り値:
    '// エラーコードを返す（詳細はエラーコード一覧を参照）。

    '// ====================================================================
    '// エラーコード一覧
    '// 成功（エラーなし）
    Public Const RY2ERR_SUCCESS As Short = 0

    '// デバイスが見つからない（パラメータエラー）
    Public Const RY2ERR_NO_SUCH_DEVICE As Integer = &HA0100001

    '// RY2_Open を呼び出さずに操作しようとした（操作エラー）
    Public Const RY2ERR_NOT_OPENED_DEVICE As Integer = &HA0100002

    '// UID が誤っている（パラメータエラー）
    Public Const RY2ERR_WRONG_UID As Integer = &HA0100003

    '// 読み書きのブロックインデックスが誤っている（パラメータエラー）
    Public Const RY2ERR_WRONG_INDEX As Integer = &HA0100004

    '// GenUID 呼び出し時に seed の長さが 64 バイトを超えている（パラメータエラー）
    Public Const RY2ERR_TOO_LONG_SEED As Integer = &HA0100005

    '// 書き込み禁止されたデバイスへの書き込みを試みた（操作エラー）
    Public Const RY2ERR_WRITE_PROTECT As Integer = &HA0100006

    '// デバイスのオープンに失敗（Windows エラー）
    Public Const RY2ERR_OPEN_DEVICE As Integer = &HA0100007

    '// 読み取りエラー（Windows エラー）
    Public Const RY2ERR_READ_REPORT As Integer = &HA0100008

    '// 書き込みエラー（Windows エラー）
    Public Const RY2ERR_WRITE_REPORT As Integer = &HA0100009

    '// 内部エラー（Windows エラー）
    Public Const RY2ERR_SETUP_DI_GET_DEVICE_INTERFACE_DETAIL As Integer = &HA010000A
    Public Const RY2ERR_GET_ATTRIBUTES As Integer = &HA010000B
    Public Const RY2ERR_GET_PREPARSED_DATA As Integer = &HA010000C
    Public Const RY2ERR_GETCAPS As Integer = &HA010000D
    Public Const RY2ERR_FREE_PREPARSED_DATA As Integer = &HA010000E
    Public Const RY2ERR_FLUSH_QUEUE As Integer = &HA010000F
    Public Const RY2ERR_SETUP_DI_CLASS_DEVS As Integer = &HA0100010
    Public Const RY2ERR_GET_SERIAL As Integer = &HA0100011
    Public Const RY2ERR_GET_PRODUCT_STRING As Integer = &HA0100012
    Public Const RY2ERR_TOO_LONG_DEVICE_DETAIL As Integer = &HA0100013

    '// 未知のデバイス（ハードウェアエラー）
    Public Const RY2ERR_UNKNOWN_DEVICE As Integer = &HA0100020

    '// 操作検証エラー（ハードウェアエラー）
    Public Const RY2ERR_VERIFY As Integer = &HA0100021

    '// 未知のエラー（ハードウェアエラー）
    Public Const RY2ERR_UNKNOWN_ERROR As Integer = &HA010FFFF
End Module